/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;
import mage.game.events.ZoneChangeEvent;

class PrecipiceOfMortisEffect
extends ReplacementEffectImpl {
    PrecipiceOfMortisEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a Jedi entering or leaving the battlefield causes a triggered ability of a permanent you control to trigger, that ability triggers additional time";
    }

    private PrecipiceOfMortisEffect(PrecipiceOfMortisEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public PrecipiceOfMortisEffect copy() {
        return new PrecipiceOfMortisEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event instanceof NumberOfTriggersEvent) {
            NumberOfTriggersEvent numberOfTriggersEvent = (NumberOfTriggersEvent)event;
            if (source.isControlledBy(event.getPlayerId())) {
                ZoneChangeEvent leavesTheBattlefieldEvent;
                EntersTheBattlefieldEvent entersTheBattlefieldEvent;
                GameEvent sourceEvent = numberOfTriggersEvent.getSourceEvent();
                if (sourceEvent != null && sourceEvent.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && sourceEvent instanceof EntersTheBattlefieldEvent && (entersTheBattlefieldEvent = (EntersTheBattlefieldEvent)sourceEvent).getTarget().hasSubtype(SubType.JEDI, game) && game.getPermanent(numberOfTriggersEvent.getSourceId()) != null) {
                    return true;
                }
                if (sourceEvent != null && sourceEvent.getType() == GameEvent.EventType.ZONE_CHANGE && sourceEvent instanceof ZoneChangeEvent && (leavesTheBattlefieldEvent = (ZoneChangeEvent)sourceEvent).getFromZone() == Zone.BATTLEFIELD && leavesTheBattlefieldEvent.getTarget().hasSubtype(SubType.JEDI, game) && game.getPermanent(numberOfTriggersEvent.getSourceId()) != null) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

