/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PriceOfGloryAbility
extends TriggeredAbilityImpl {
    private static final String staticText = "Whenever a player taps a land for mana, if it's not that player's turn, destroy that land.";

    PriceOfGloryAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DestroyTargetEffect());
    }

    private PriceOfGloryAbility(PriceOfGloryAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.inCheckPlayableState()) {
            return false;
        }
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        if (permanent == null || !permanent.isLand(game) || game.isActivePlayer(event.getPlayerId())) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        return true;
    }

    public PriceOfGloryAbility copy() {
        return new PriceOfGloryAbility(this);
    }

    public String getRule() {
        return staticText;
    }
}

