/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PriceOfKnowledgeEffect
extends OneShotEffect {
    private PriceOfKnowledgeEffect(PriceOfKnowledgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public PriceOfKnowledgeEffect() {
        super(Outcome.Neutral);
        this.staticText = "{this} deals damage to that player equal to the number of cards in that player's hand";
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            int xValue = targetPlayer.getHand().size();
            if (xValue > 0) {
                targetPlayer.damage(xValue, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }

    public PriceOfKnowledgeEffect copy() {
        return new PriceOfKnowledgeEffect(this);
    }
}

