/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;

enum PriestOfTheBlessedGrafValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return PriestOfTheBlessedGrafValue.makeStream(game, sourceAbility).size();
    }

    public PriestOfTheBlessedGrafValue copy() {
        return this;
    }

    public String getMessage() {
        return "the number of opponents who control more lands than you";
    }

    public String toString() {
        return "X";
    }

    static List<String> makeStream(Game game, Ability source) {
        Map map = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), source, game).stream().map(Controllable::getControllerId).collect(Collectors.toMap(Function.identity(), u -> 1, Integer::sum));
        int myLands = map.getOrDefault(source.getControllerId(), 0);
        return game.getOpponents(source.getControllerId()).stream().filter(playerId -> map.getOrDefault(playerId, 0) > myLands).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getName).collect(Collectors.toList());
    }
}

