/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class PriestOfTheWakeningSunEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a Dinosaur card to reveal");

    PriestOfTheWakeningSunEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal a Dinosaur card from your hand. If you do, you gain 2 life";
    }

    private PriestOfTheWakeningSunEffect(PriestOfTheWakeningSunEffect effect) {
        super((OneShotEffect)effect);
    }

    public PriestOfTheWakeningSunEffect copy() {
        return new PriestOfTheWakeningSunEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInHand target;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null && controller.getHand().count(filter, source.getControllerId(), source, game) > 0 && controller.chooseUse(this.outcome, "Reveal a Dinosaur card?", source, game) && controller.chooseTarget(this.outcome, (Target)(target = new TargetCardInHand(0, 1, filter)), source, game) && !target.getTargets().isEmpty()) {
            CardsImpl cards = new CardsImpl((Collection)target.getTargets());
            controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            controller.gainLife(2, game, source);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.DINOSAUR.getPredicate());
    }
}

