/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.abilities.keyword.DefenderAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

public final class PrimalPlasma
extends CardImpl {
    public PrimalPlasma(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{U}");
        this.subtype.add((Object)SubType.ELEMENTAL);
        this.subtype.add((Object)SubType.SHAPESHIFTER);
        this.power = new MageInt(0);
        this.toughness = new MageInt(0);
        this.addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new PrimalPlasmaReplacementEffect()));
    }

    private PrimalPlasma(PrimalPlasma card) {
        super((CardImpl)card);
    }

    public PrimalPlasma copy() {
        return new PrimalPlasma(this);
    }

    static class PrimalPlasmaReplacementEffect
    extends ReplacementEffectImpl {
        private static final String choice33 = "a 3/3 creature";
        private static final String choice22 = "a 2/2 creature with flying";
        private static final String choice16 = "a 1/6 creature with defender";

        public PrimalPlasmaReplacementEffect() {
            super(Duration.WhileOnBattlefield, Outcome.Benefit);
            this.staticText = "As {this} enters, it becomes your choice of a 3/3 creature, a 2/2 creature with flying, or a 1/6 creature with defender";
        }

        private PrimalPlasmaReplacementEffect(PrimalPlasmaReplacementEffect effect) {
            super((ReplacementEffectImpl)effect);
        }

        public boolean checksEventType(GameEvent event, Game game) {
            return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
        }

        public boolean applies(GameEvent event, Ability source, Game game) {
            if (event.getTargetId().equals(source.getSourceId())) {
                Permanent sourcePermanent = ((EntersTheBattlefieldEvent)event).getTarget();
                return sourcePermanent != null && !sourcePermanent.isFaceDown(game);
            }
            return false;
        }

        public boolean replaceEvent(GameEvent event, Ability source, Game game) {
            Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
            Player controller = game.getPlayer(source.getControllerId());
            if (permanent != null && controller != null) {
                ChoiceImpl choice = new ChoiceImpl(true);
                choice.setMessage("Choose what " + permanent.getIdName() + " becomes to");
                choice.getChoices().add(choice33);
                choice.getChoices().add(choice22);
                choice.getChoices().add(choice16);
                if (!controller.choose(Outcome.Neutral, (Choice)choice, game)) {
                    return false;
                }
                int power = 0;
                int toughness = 0;
                switch (choice.getChoice()) {
                    case "a 3/3 creature": {
                        power = 3;
                        toughness = 3;
                        break;
                    }
                    case "a 2/2 creature with flying": {
                        power = 2;
                        toughness = 2;
                        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.Custom), source);
                        break;
                    }
                    case "a 1/6 creature with defender": {
                        power = 1;
                        toughness = 6;
                        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)DefenderAbility.getInstance(), Duration.Custom), source);
                    }
                }
                game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(power, toughness, Duration.WhileOnBattlefield), source);
            }
            return false;
        }

        public PrimalPlasmaReplacementEffect copy() {
            return new PrimalPlasmaReplacementEffect(this);
        }
    }
}

