/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PrimalSurgeEffect
extends OneShotEffect {
    PrimalSurgeEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Exile the top card of your library. If it's a permanent card, you may put it onto the battlefield. If you do, repeat this process";
    }

    private PrimalSurgeEffect(PrimalSurgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrimalSurgeEffect copy() {
        return new PrimalSurgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        while ((card = controller.getLibrary().getFromTop(game)) != null && controller.moveCards(card, Zone.EXILED, source, game) && card.isPermanent(game) && controller.chooseUse(Outcome.PutCardInPlay, "Put " + card.getName() + " onto the battlefield?", source, game)) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            if (controller.canRespond()) continue;
        }
        return true;
    }
}

