/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class PrimeSpeakerVannifarEffect
extends OneShotEffect {
    PrimeSpeakerVannifarEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for a creature card with mana value equal to 1 plus the sacrificed creature's mana value, put that card onto the battlefield, then shuffle";
    }

    private PrimeSpeakerVannifarEffect(PrimeSpeakerVannifarEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sacrificedPermanent = null;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            SacrificeTargetCost sacrificeCost = (SacrificeTargetCost)cost;
            if (sacrificeCost.getPermanents().isEmpty()) break;
            sacrificedPermanent = (Permanent)sacrificeCost.getPermanents().get(0);
            break;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (sacrificedPermanent == null || controller == null) {
            return false;
        }
        int newConvertedCost = sacrificedPermanent.getManaValue() + 1;
        FilterCard filter = new FilterCard("creature card with mana value " + newConvertedCost);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, newConvertedCost));
        filter.add((Predicate)CardType.CREATURE.getPredicate());
        TargetCardInLibrary target = new TargetCardInLibrary(filter);
        if (controller.searchLibrary(target, source, game)) {
            Card card = controller.getLibrary().getCard(target.getFirstTarget(), game);
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        controller.shuffleLibrary(source, game);
        return true;
    }

    public PrimeSpeakerVannifarEffect copy() {
        return new PrimeSpeakerVannifarEffect(this);
    }
}

