/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class PrimevalProtectorCostReductionEffect
extends CostModificationEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("each creature your opponents control");

    PrimevalProtectorCostReductionEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "this spell costs {1} less to cast for each creature your opponents control";
    }

    private PrimevalProtectorCostReductionEffect(PrimevalProtectorCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int reductionAmount = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
            CardUtil.reduceCost((Ability)abilityToModify, (int)reductionAmount);
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId())) {
            return game.getCard(abilityToModify.getSourceId()) != null;
        }
        return false;
    }

    public PrimevalProtectorCostReductionEffect copy() {
        return new PrimevalProtectorCostReductionEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
    }
}

