/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.p.PrimevalSpawnTracker;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class PrimevalSpawnSpellEffect
extends OneShotEffect {
    PrimevalSpawnSpellEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top ten cards of your library. You may cast any number of spells with total mana value 10 or less from among them without paying their mana costs";
    }

    private PrimevalSpawnSpellEffect(PrimevalSpawnSpellEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrimevalSpawnSpellEffect copy() {
        return new PrimevalSpawnSpellEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 10));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        game.processAction();
        cards.retainZone(Zone.EXILED, game);
        CardUtil.castMultipleWithAttributeForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD, (int)Integer.MAX_VALUE, (CardUtil.SpellCastTracker)new PrimevalSpawnTracker());
        return true;
    }
}

