/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PrinceOfThrallsTriggeredAbility
extends TriggeredAbilityImpl {
    PrinceOfThrallsTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect, false);
        this.setTriggerPhrase("Whenever a permanent an opponent controls is put into a graveyard, ");
    }

    private PrinceOfThrallsTriggeredAbility(PrinceOfThrallsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PrinceOfThrallsTriggeredAbility copy() {
        return new PrinceOfThrallsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent()) {
            Permanent permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD);
            if (game.getOpponents(this.getControllerId()).contains(permanent.getControllerId())) {
                for (Effect effect : this.getEffects()) {
                    effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game.getState().getZoneChangeCounter(event.getTargetId())));
                }
                return true;
            }
        }
        return false;
    }
}

