/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.p.PriorityBoardingEffect;
import mage.constants.RollDieType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DieRolledEvent;
import mage.game.events.GameEvent;

class PriorityBoardingTriggeredAbility
extends TriggeredAbilityImpl {
    PriorityBoardingTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new PriorityBoardingEffect(), true);
        this.setDoOnlyOnceEachTurn(true);
    }

    private PriorityBoardingTriggeredAbility(PriorityBoardingTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DIE_ROLLED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DieRolledEvent drEvent = (DieRolledEvent)event;
        if (this.isControlledBy(event.getTargetId()) && drEvent.getRollDieType() == RollDieType.NUMERICAL) {
            int result = drEvent.getResult();
            this.getEffects().setValue("rolled", (Object)result);
            return true;
        }
        return false;
    }

    public PriorityBoardingTriggeredAbility copy() {
        return new PriorityBoardingTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you roll a die, you may reveal the top card of your library. Do this only once each turn. Whenever you reveal a card with mana value less than the result this way, you may exile it. If you do, you may play it this turn.";
    }
}

