/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.ObjectColor;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class PrismRingTriggeredAbility
extends TriggeredAbilityImpl {
    public PrismRingTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainLifeEffect(1), false);
    }

    private PrismRingTriggeredAbility(PrismRingTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getPlayerId().equals(this.getControllerId())) {
            Spell spell = game.getStack().getSpell(event.getTargetId());
            ObjectColor color = (ObjectColor)game.getState().getValue(this.getSourceId() + "_color");
            if (spell != null && color != null && spell.getColor(game).shares(color)) {
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever you cast a spell of the chosen color, you gain 1 life.";
    }

    public PrismRingTriggeredAbility copy() {
        return new PrismRingTriggeredAbility(this);
    }
}

