/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.constants.ComparisonType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureCard;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetadjustment.TargetAdjuster;
import mage.util.CardUtil;

enum ProfaneCommandAdjuster implements TargetAdjuster
{
    instance;


    public void adjustTargets(Ability ability, Game game) {
        Mode mode = ability.getModes().getMode();
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)ability, (String)"X", (Object)0);
        for (Effect effect : mode.getEffects()) {
            FilterCreaturePermanent filter;
            if (effect instanceof ReturnFromGraveyardToBattlefieldTargetEffect) {
                mode.getTargets().clear();
                filter = new FilterCreatureCard("creature card with mana value " + xValue + " or less from your graveyard");
                filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
                mode.addTarget((Target)new TargetCardInYourGraveyard((FilterCard)filter));
            }
            if (!(effect instanceof GainAbilityTargetEffect)) continue;
            mode.getTargets().clear();
            filter = new FilterCreaturePermanent("creatures gain fear until end of turn");
            mode.addTarget((Target)new TargetPermanent(0, xValue, (FilterPermanent)filter));
        }
    }
}

