/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.constants.WatcherScope;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class ProfessorHojoWatcher
extends Watcher {
    private final Set<UUID> set = new HashSet<UUID>();

    ProfessorHojoWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ACTIVATED_ABILITY) {
            return;
        }
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (stackObject != null && stackObject.getStackAbility() instanceof ActivatedAbility) {
            if (CardUtil.getAllSelectedTargets((Ability)stackObject.getStackAbility(), (Game)game).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(permanent -> permanent.isCreature(game)).map(Controllable::getControllerId).anyMatch(arg_0 -> ((StackObject)stackObject).isControlledBy(arg_0))) {
                this.set.add(stackObject.getControllerId());
            }
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((ProfessorHojoWatcher)game.getState().getWatcher(ProfessorHojoWatcher.class)).set.contains(source.getControllerId());
    }
}

