/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class ProperBurialTriggeredAbility
extends TriggeredAbilityImpl {
    public ProperBurialTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private ProperBurialTriggeredAbility(ProperBurialTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ProperBurialTriggeredAbility copy() {
        return new ProperBurialTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        ZoneChangeEvent zoneChangeEvent = (ZoneChangeEvent)event;
        if (zoneChangeEvent.isDiesEvent() && (permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD)) != null && permanent.isControlledBy(this.getControllerId()) && permanent.isCreature(game)) {
            this.getEffects().clear();
            this.addEffect((Effect)new GainLifeEffect(permanent.getToughness().getValue()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you control dies, you gain life equal to that creature's toughness.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

