/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;

class ProteusStaffEffect
extends OneShotEffect {
    ProteusStaffEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Put target creature on the bottom of its owner's library. That creature's controller reveals cards from the top of their library until they reveal a creature card. The player puts that card onto the battlefield and the rest on the bottom of their library in any order.";
    }

    private ProteusStaffEffect(ProteusStaffEffect effect) {
        super((OneShotEffect)effect);
    }

    public ProteusStaffEffect copy() {
        return new ProteusStaffEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            Player owner = game.getPlayer(permanent.getOwnerId());
            Player controller = game.getPlayer(permanent.getControllerId());
            if (owner != null && controller != null) {
                owner.moveCardToLibraryWithInfo((Card)permanent, source, game, Zone.BATTLEFIELD, false, true);
                CardsImpl cards = new CardsImpl();
                for (Card card : controller.getLibrary().getCards(game)) {
                    if (card == null) continue;
                    if (card.isCreature(game)) {
                        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                        break;
                    }
                    cards.add(card);
                }
                controller.revealCards("Proteus Staff", (Cards)cards, game);
                while (!cards.isEmpty() && controller.canRespond()) {
                    Card card;
                    if (cards.size() == 1) {
                        Card card2 = cards.get((UUID)cards.iterator().next(), game);
                        if (card2 == null) continue;
                        controller.moveCardToLibraryWithInfo(card2, source, game, Zone.LIBRARY, false, false);
                        cards.remove(card2);
                        continue;
                    }
                    TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to put on bottom of your library (last chosen will be on bottom)"));
                    controller.choose(Outcome.Neutral, (Cards)cards, target, source, game);
                    card = cards.get(target.getFirstTarget(), game);
                    if (card == null) continue;
                    controller.moveCardToLibraryWithInfo(card, source, game, Zone.LIBRARY, false, false);
                    cards.remove(card);
                }
                return true;
            }
        }
        return false;
    }
}

