/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ProvokeTheTrollsEffect
extends OneShotEffect {
    ProvokeTheTrollsEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 3 damage to any target. If a creature is dealt damage this way, it gets +5/+0 until end of turn";
    }

    private ProvokeTheTrollsEffect(ProvokeTheTrollsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ProvokeTheTrollsEffect copy() {
        return new ProvokeTheTrollsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            return player.damage(3, source.getSourceId(), source, game) > 0;
        }
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null || permanent.damage(3, source.getSourceId(), source, game) < 1) {
            return false;
        }
        if (permanent.isCreature(game)) {
            game.addEffect((ContinuousEffect)new BoostTargetEffect(3, 0), source);
        }
        return true;
    }
}

