/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class PryingQuestionsEffect
extends OneShotEffect {
    PryingQuestionsEffect() {
        super(Outcome.Detriment);
        this.staticText = "puts a card from their hand on top of their library";
    }

    private PryingQuestionsEffect(PryingQuestionsEffect effect) {
        super((OneShotEffect)effect);
    }

    public PryingQuestionsEffect copy() {
        return new PryingQuestionsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetOpponent != null) {
            if (!targetOpponent.getHand().isEmpty()) {
                TargetCardInHand target = new TargetCardInHand().withChooseHint("to put on top of your library");
                targetOpponent.choose(Outcome.Detriment, (Target)target, source, game);
                Card card = targetOpponent.getHand().get(target.getFirstTarget(), game);
                if (card != null) {
                    targetOpponent.moveCardToLibraryWithInfo(card, source, game, Zone.HAND, true, false);
                }
            }
            return true;
        }
        return false;
    }
}

