/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.p.PsychicBattleEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PsychicBattleTriggeredAbility
extends TriggeredAbilityImpl {
    public PsychicBattleTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new PsychicBattleEffect(), false);
    }

    private PsychicBattleTriggeredAbility(PsychicBattleTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PsychicBattleTriggeredAbility copy() {
        return new PsychicBattleTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGETED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (stackObject != null && !stackObject.isTargetChanged() && !stackObject.getName().equals("Psychic Battle")) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId()));
            stackObject.setTargetChanged(false);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a player chooses one or more targets, each player reveals the top card of their library. The player who reveals the card with the highest mana value may change the target or targets. If two or more cards are tied for highest, the target or targets remain unchanged. Changing targets this way doesn't trigger abilities of permanents named Psychic Battle.";
    }
}

