/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class PsychoticEpisodeEffect
extends OneShotEffect {
    PsychoticEpisodeEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player reveals their hand and the top card of their library. You choose a card revealed this way. That player puts the chosen card on the bottom of their library.";
    }

    private PsychoticEpisodeEffect(PsychoticEpisodeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (player != null && controller != null && sourceObject != null) {
            Card card;
            TargetCard targetCard = new TargetCard(Zone.ALL, new FilterCard());
            targetCard.setRequired(true);
            Cards options = player.getHand().copy();
            Card topdeck = player.getLibrary().getFromTop(game);
            options.add(topdeck);
            player.revealCards("Hand: " + sourceObject.getIdName(), player.getHand(), game);
            player.revealCards("Top of Library: " + sourceObject.getIdName(), (Cards)new CardsImpl(topdeck), game);
            if (controller.choose(Outcome.Discard, options, targetCard, source, game) && (card = game.getCard(targetCard.getFirstTarget())) != null) {
                game.informPlayers(card.getLogName() + " was chosen.");
                player.putCardsOnBottomOfLibrary(card, game, source);
            }
            return true;
        }
        return false;
    }

    public PsychoticEpisodeEffect copy() {
        return new PsychoticEpisodeEffect(this);
    }
}

