/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerSourceEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;

class PuPuUFOEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.TOWN);
    private static final Hint hint = new ValueHint("Towns you control", (DynamicValue)new PermanentsOnBattlefieldCount(filter));

    public static Hint getHint() {
        return hint;
    }

    PuPuUFOEffect() {
        super(Outcome.Benefit);
        this.staticText = "until end of turn, {this}'s base power becomes equal to the number of Towns you control";
    }

    private PuPuUFOEffect(PuPuUFOEffect effect) {
        super((OneShotEffect)effect);
    }

    public PuPuUFOEffect copy() {
        return new PuPuUFOEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (source.getSourcePermanentIfItStillExists(game) == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new SetBasePowerSourceEffect(game.getBattlefield().count(filter, source.getControllerId(), source, game), Duration.EndOfTurn), source);
        return true;
    }
}

