/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ClashEffect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PullingTeethEffect
extends OneShotEffect {
    PullingTeethEffect() {
        super(Outcome.Discard);
        this.staticText = "Clash with an opponent. If you win, target player discards two cards. Otherwise, that player discards a card";
    }

    private PullingTeethEffect(PullingTeethEffect effect) {
        super((OneShotEffect)effect);
    }

    public PullingTeethEffect copy() {
        return new PullingTeethEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int cardsToDiscard = new ClashEffect().apply(game, source) ? 2 : 1;
            DiscardTargetEffect effect = new DiscardTargetEffect(cardsToDiscard);
            effect.apply(game, source);
            return true;
        }
        return false;
    }
}

