/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PulseOfTheForgeReturnToHandEffect
extends OneShotEffect {
    PulseOfTheForgeReturnToHandEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if that player or that planeswalker's controller has more life than you, return {this} to its owner's hand";
    }

    private PulseOfTheForgeReturnToHandEffect(PulseOfTheForgeReturnToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public PulseOfTheForgeReturnToHandEffect copy() {
        return new PulseOfTheForgeReturnToHandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayerOrPlaneswalkerController(source.getControllerId());
        if (controller != null && (player = game.getPlayer(source.getFirstTarget())) != null && player.getLife() > controller.getLife()) {
            Card card = game.getCard(source.getSourceId());
            controller.moveCards(card, Zone.HAND, source, game);
            return true;
        }
        return false;
    }
}

