/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PulseOfTheGridReturnToHandEffect
extends OneShotEffect {
    PulseOfTheGridReturnToHandEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if an opponent has more cards in hand than you, return {this} to its owner's hand";
    }

    private PulseOfTheGridReturnToHandEffect(PulseOfTheGridReturnToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public PulseOfTheGridReturnToHandEffect copy() {
        return new PulseOfTheGridReturnToHandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || player.getHand().size() <= controller.getHand().size()) continue;
                Card card = game.getCard(source.getSourceId());
                controller.moveCards(card, Zone.HAND, source, game);
                return true;
            }
        }
        return false;
    }
}

