/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class PulsemageAdvocateEffect
extends OneShotEffect {
    PulsemageAdvocateEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return three target cards from an opponent's graveyard to their hand. Return target creature card from your graveyard to the battlefield";
    }

    private PulsemageAdvocateEffect(PulsemageAdvocateEffect effect) {
        super((OneShotEffect)effect);
    }

    public PulsemageAdvocateEffect copy() {
        return new PulsemageAdvocateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl();
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Card card = game.getCard(targetId);
                if (card == null) continue;
                cards.add(card);
            }
            controller.moveCards((Cards)cards, Zone.HAND, source, game);
            Card card = controller.getGraveyard().get(((Target)source.getTargets().get(1)).getFirstTarget(), game);
            if (card != null) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

