/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnFromGraveyardToHandTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PureIntentionsAllTriggeredAbility
extends DelayedTriggeredAbility {
    public PureIntentionsAllTriggeredAbility() {
        super((Effect)new ReturnFromGraveyardToHandTargetEffect(), Duration.EndOfTurn, false);
    }

    private PureIntentionsAllTriggeredAbility(PureIntentionsAllTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DISCARDED_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Card card;
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (stackObject != null && game.getOpponents(this.getControllerId()).contains(stackObject.getControllerId()) && (card = game.getCard(event.getTargetId())) != null && card.isOwnedBy(this.getControllerId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
            }
            return true;
        }
        return false;
    }

    public PureIntentionsAllTriggeredAbility copy() {
        return new PureIntentionsAllTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a spell or ability an opponent controls causes you to discard cards this turn, return those cards from your graveyard to your hand.";
    }
}

