/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.token.ReflectionPureToken;
import mage.game.stack.Spell;
import mage.players.Player;

class PureReflectionEffect
extends OneShotEffect {
    PureReflectionEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy all Reflections. Then that player creates an X/X white Reflection creature token, where X is the mana value of that spell.";
    }

    private PureReflectionEffect(PureReflectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || game.getPermanentOrLKIBattlefield(source.getSourceId()) == null) {
            return false;
        }
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent("Reflections");
        filter.add((Predicate)SubType.REFLECTION.getPredicate());
        game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game).forEach(permanent -> permanent.destroy(source, game, false));
        game.processAction();
        ReflectionPureToken token = new ReflectionPureToken(spell.getManaValue());
        token.putOntoBattlefield(1, game, source, spell.getControllerId());
        return true;
    }

    public PureReflectionEffect copy() {
        return new PureReflectionEffect(this);
    }
}

