/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class PurgingScytheEffect
extends OneShotEffect {
    PurgingScytheEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "{this} deals 2 damage to the creature with the least toughness. If two or more creatures are tied for least toughness, you choose one of them";
    }

    private PurgingScytheEffect(PurgingScytheEffect effect) {
        super((OneShotEffect)effect);
    }

    public PurgingScytheEffect copy() {
        return new PurgingScytheEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            int leastToughness = Integer.MAX_VALUE;
            boolean multipleExist = false;
            Permanent permanentToDamage = null;
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), game)) {
                if (permanent.getToughness().getValue() < leastToughness) {
                    permanentToDamage = permanent;
                    leastToughness = permanent.getToughness().getValue();
                    multipleExist = false;
                    continue;
                }
                if (permanent.getToughness().getValue() != leastToughness) continue;
                multipleExist = true;
            }
            if (multipleExist) {
                FilterCreaturePermanent filter = new FilterCreaturePermanent("one of the creatures with the least toughness");
                filter.add((Predicate)new ToughnessPredicate(ComparisonType.EQUAL_TO, leastToughness));
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                target.withNotTarget(true);
                if (target.canChoose(source.getControllerId(), source, game) && controller.choose(this.outcome, (Target)target, source, game)) {
                    permanentToDamage = game.getPermanent(target.getFirstTarget());
                }
            }
            if (permanentToDamage != null) {
                game.informPlayers(sourcePermanent.getName() + " chosen creature: " + permanentToDamage.getName());
                return permanentToDamage.damage(2, source.getSourceId(), source, game, false, true) > 0;
            }
            return true;
        }
        return false;
    }
}

