/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.players.Player;

class PurityEffect
extends PreventionEffectImpl {
    PurityEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, false, false);
        this.staticText = "If noncombat damage would be dealt to you, prevent that damage. You gain life equal to the damage prevented this way";
    }

    private PurityEffect(PurityEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionData = this.preventDamageAction(event, source, game);
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.gainLife(preventionData.getPreventedDamage(), game, source);
        }
        return true;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game)) {
            return !((DamageEvent)event).isCombatDamage() && event.getTargetId().equals(source.getControllerId());
        }
        return false;
    }

    public PurityEffect copy() {
        return new PurityEffect(this);
    }
}

