/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class PushTheLimitEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Mount and Vehicle cards");

    PushTheLimitEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "return all " + filter.getMessage() + " from your graveyard to the battlefield. Sacrifice them at the beginning of the next end step.";
    }

    private PushTheLimitEffect(PushTheLimitEffect effect) {
        super((OneShotEffect)effect);
    }

    public PushTheLimitEffect copy() {
        return new PushTheLimitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set cards = controller.getGraveyard().getCards(filter, source.getControllerId(), source, game);
        boolean result = controller.moveCards(cards, Zone.BATTLEFIELD, source, game, false, false, false, null);
        if (result) {
            List permanentsToSac = cards.stream().map(card -> CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)).filter(Objects::nonNull).collect(Collectors.toList());
            SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("sacrifice them", source.getControllerId());
            sacrificeEffect.setTargetPointer((TargetPointer)new FixedTargets(permanentsToSac, game));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect), source);
        }
        return result;
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.MOUNT.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
    }
}

