/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class PyromancerAscensionQuestTriggeredAbility
extends TriggeredAbilityImpl {
    PyromancerAscensionQuestTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.QUEST.createInstance(), true), true);
    }

    private PyromancerAscensionQuestTriggeredAbility(PyromancerAscensionQuestTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PyromancerAscensionQuestTriggeredAbility copy() {
        return new PyromancerAscensionQuestTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Card sourceCard;
        Spell spell;
        if (event.getPlayerId().equals(this.getControllerId()) && this.isControlledInstantOrSorcery(spell = game.getStack().getSpell(event.getTargetId()), game) && (sourceCard = game.getCard(spell.getSourceId())) != null) {
            for (UUID uuid : game.getPlayer(this.getControllerId()).getGraveyard()) {
                Card card;
                if (uuid.equals(sourceCard.getId()) || !CardUtil.haveSameNames((MageObject)(card = game.getCard(uuid)), (MageObject)sourceCard)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isControlledInstantOrSorcery(Spell spell, Game game) {
        return spell != null && spell.isControlledBy(this.getControllerId()) && spell.isInstantOrSorcery(game);
    }

    public String getRule() {
        return "Whenever you cast an instant or sorcery spell that has the same name as a card in your graveyard, you may put a quest counter on {this}.";
    }
}

