/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PyrostaticPillarTriggeredAbility
extends TriggeredAbilityImpl {
    public PyrostaticPillarTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(2, true, "that player"));
    }

    private PyrostaticPillarTriggeredAbility(PyrostaticPillarTriggeredAbility abiltity) {
        super((TriggeredAbilityImpl)abiltity);
    }

    public PyrostaticPillarTriggeredAbility copy() {
        return new PyrostaticPillarTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && spell.getManaValue() <= 3) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a player casts a spell with mana value 3 or less, {this} deals 2 damage to that player.";
    }
}

