/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class PyxisOfPandemoniumPutOntoBattlefieldEffect
extends OneShotEffect {
    PyxisOfPandemoniumPutOntoBattlefieldEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Each player turns face up all cards they own exiled with {this}, then puts all permanent cards among them onto the battlefield";
    }

    private PyxisOfPandemoniumPutOntoBattlefieldEffect(PyxisOfPandemoniumPutOntoBattlefieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public PyxisOfPandemoniumPutOntoBattlefieldEffect copy() {
        return new PyxisOfPandemoniumPutOntoBattlefieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent pyxis = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && pyxis != null) {
            String valueKey = CardUtil.getObjectZoneString((String)"exileIds", (MageObject)pyxis, (Game)game);
            Object object = game.getState().getValue(valueKey);
            if (!(object instanceof Map)) {
                return true;
            }
            Map exileIds = (Map)object;
            CardsImpl cardsToBringIntoPlay = new CardsImpl();
            game.getState().getPlayersInRange(controller.getId(), game).forEach(arg_0 -> PyxisOfPandemoniumPutOntoBattlefieldEffect.lambda$apply$3(game, source, pyxis, exileIds, (Cards)cardsToBringIntoPlay, arg_0));
            controller.moveCards(cardsToBringIntoPlay.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$apply$3(Game game, Ability source, Permanent pyxis, Map exileIds, Cards cardsToBringIntoPlay, UUID playerId) {
        ExileZone exileZone;
        String exileKey;
        UUID exileId;
        Player player = game.getPlayer(playerId);
        if (player != null && (exileId = (UUID)exileIds.get(exileKey = playerId.toString() + CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)pyxis.getZoneChangeCounter(game)))) != null && (exileZone = game.getState().getExile().getExileZone(exileId)) != null) {
            exileZone.getCards(game).stream().map(card -> {
                card.setFaceDown(false, game);
                return card;
            }).filter(card -> card.isPermanent(game)).forEachOrdered(card -> cardsToBringIntoPlay.add(card));
        }
    }
}

