/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;

class QuakebringerTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.GIANT);

    QuakebringerTriggeredAbility() {
        super(Zone.ALL, (Effect)new DamagePlayersEffect(2, TargetController.OPPONENT));
    }

    private QuakebringerTriggeredAbility(QuakebringerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        switch (game.getState().getZone(this.getSourceId())) {
            case BATTLEFIELD: {
                return game.isActivePlayer(this.getControllerId());
            }
            case GRAVEYARD: {
                return game.isActivePlayer(game.getOwnerId(this.getSourceId())) && game.getBattlefield().count(filter, this.getControllerId(), (Ability)this, game) > 0;
            }
        }
        return false;
    }

    public QuakebringerTriggeredAbility copy() {
        return new QuakebringerTriggeredAbility(this);
    }

    public String getRule() {
        return "At the beginning of your upkeep, {this} deals 2 damage to each opponent. This ability triggers only if {this} is on the battlefield or if {this} is in your graveyard and you control a Giant.";
    }
}

