/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class QuestForPureFlameEffect
extends ReplacementEffectImpl {
    QuestForPureFlameEffect() {
        super(Duration.EndOfTurn, Outcome.Damage);
        this.staticText = "If any source you control would deal damage to a permanent or player this turn, it deals double that damage to that permanent or player instead";
    }

    private QuestForPureFlameEffect(QuestForPureFlameEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public QuestForPureFlameEffect copy() {
        return new QuestForPureFlameEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(game.getControllerId(event.getSourceId()));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

