/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class QuestForUlasTempleEffect
extends OneShotEffect {
    QuestForUlasTempleEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may look at the top card of your library. If it's a creature card, you may reveal it and put a quest counter on {this}";
    }

    private QuestForUlasTempleEffect(QuestForUlasTempleEffect effect) {
        super((OneShotEffect)effect);
    }

    public QuestForUlasTempleEffect copy() {
        return new QuestForUlasTempleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        controller.lookAtCards("Top of library", card, game);
        if (!card.isCreature(game) || !controller.chooseUse(Outcome.DrawCard, "Reveal the top card of your library?", source, game)) {
            return true;
        }
        controller.revealCards(source, (Cards)new CardsImpl(card), game);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            permanent.addCounters(CounterType.QUEST.createInstance(), source.getControllerId(), source, game);
        }
        return true;
    }
}

