/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.q.QuickenWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class QuickenAsThoughEffect
extends AsThoughEffectImpl {
    private QuickenWatcher quickenWatcher;
    private int zoneChangeCounter;

    public QuickenAsThoughEffect() {
        super(AsThoughEffectType.CAST_AS_INSTANT, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "The next sorcery spell you cast this turn can be cast as though it had flash";
    }

    private QuickenAsThoughEffect(QuickenAsThoughEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.quickenWatcher = effect.quickenWatcher;
        this.zoneChangeCounter = effect.zoneChangeCounter;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.quickenWatcher = (QuickenWatcher)game.getState().getWatcher(QuickenWatcher.class);
        Card card = game.getCard(source.getSourceId());
        if (this.quickenWatcher != null && card != null) {
            this.zoneChangeCounter = card.getZoneChangeCounter(game);
            this.quickenWatcher.addQuickenSpell(source.getControllerId(), source.getSourceId(), this.zoneChangeCounter);
        }
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public QuickenAsThoughEffect copy() {
        return new QuickenAsThoughEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Card card;
        return this.quickenWatcher.isQuickenSpellActive(affectedControllerId, source.getSourceId(), this.zoneChangeCounter) && (card = game.getCard(sourceId)) != null && card.isSorcery(game) && source.isControlledBy(affectedControllerId);
    }
}

