/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;

class QuintoriusLoremasterReplacementEffect
extends ReplacementEffectImpl {
    private final MageObjectReference mor;

    QuintoriusLoremasterReplacementEffect(Card card, Game game) {
        super(Duration.EndOfTurn, Outcome.Exile);
        this.mor = new MageObjectReference((MageObject)card, game, 1);
    }

    private QuintoriusLoremasterReplacementEffect(QuintoriusLoremasterReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.mor = effect.mor;
    }

    public QuintoriusLoremasterReplacementEffect copy() {
        return new QuintoriusLoremasterReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = this.mor.getCard(game);
        return controller != null && card != null && controller.putCardsOnBottomOfLibrary(card, game, source);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(this.mor.getSourceId()) && ((ZoneChangeEvent)event).getFromZone() == Zone.STACK && ((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD && this.mor.zoneCounterIsCurrent(game);
    }
}

