/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class SearchLibraryPutInGraveEffect
extends SearchEffect {
    SearchLibraryPutInGraveEffect(TargetCardInLibrary target) {
        super(target, Outcome.Neutral);
        this.staticText = "Search target player's library for up to three cards with flashback and put them into that player's graveyard. Then the player shuffles.";
    }

    private SearchLibraryPutInGraveEffect(SearchLibraryPutInGraveEffect effect) {
        super((SearchEffect)effect);
    }

    public SearchLibraryPutInGraveEffect copy() {
        return new SearchLibraryPutInGraveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        UUID targetPlayerID = source.getFirstTarget();
        if (controller == null) {
            return false;
        }
        if (targetPlayerID != null && controller.searchLibrary(this.target, source, game, targetPlayerID)) {
            if (!this.target.getTargets().isEmpty()) {
                CardsImpl cards = new CardsImpl((Collection)this.target.getTargets());
                controller.revealCards("Quiet Speculation", (Cards)cards, game);
                controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        controller.shuffleLibrary(source, game);
        return false;
    }
}

