/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class OpponentGainControlEffect
extends ContinuousEffectImpl {
    private UUID opponentId;

    public OpponentGainControlEffect() {
        super(Duration.Custom, Layer.ControlChangingEffects_2, SubLayer.NA, Outcome.Detriment);
        this.staticText = "an opponent gains control of {this}";
        this.opponentId = null;
    }

    private OpponentGainControlEffect(OpponentGainControlEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.opponentId = effect.opponentId;
    }

    public void init(Ability source, Game game) {
        Player targetOpponent;
        super.init(source, game);
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            if (game.getOpponents(controller.getId()).size() == 1) {
                this.opponentId = (UUID)game.getOpponents(controller.getId()).iterator().next();
            } else {
                TargetOpponent target = new TargetOpponent(true);
                controller.chooseTarget(this.outcome, (Target)target, source, game);
                this.opponentId = target.getFirstTarget();
            }
        }
        if ((targetOpponent = game.getPlayer(this.opponentId)) != null && permanent != null) {
            game.informPlayers(permanent.getLogName() + " is now controlled by " + targetOpponent.getLogName());
        } else {
            this.discard();
        }
    }

    public OpponentGainControlEffect copy() {
        return new OpponentGainControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetOpponent = game.getPlayer(this.opponentId);
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && targetOpponent != null) {
            permanent.changeControllerId(this.opponentId, game, source);
        } else {
            this.discard();
        }
        return true;
    }
}

