/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class RadiantGraceEffect
extends OneShotEffect {
    RadiantGraceEffect() {
        super(Outcome.Benefit);
        this.staticText = "return this card to the battlefield transformed under your control attached to target opponent";
    }

    private RadiantGraceEffect(RadiantGraceEffect effect) {
        super((OneShotEffect)effect);
    }

    public RadiantGraceEffect copy() {
        return new RadiantGraceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null || game.getState().getZone(source.getSourceId()) != Zone.GRAVEYARD) {
            return false;
        }
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        game.getState().setValue("EnterTransformed" + source.getSourceId(), (Object)Boolean.TRUE);
        game.getState().setValue("attachTo:" + source.getSourceId(), (Object)player.getId());
        if (controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            player.addAttachment(card.getId(), source, game);
        }
        return true;
    }
}

