/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.r.RadiantScrollwielderWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class RadiantScrollwielderReplacementEffect
extends ReplacementEffectImpl {
    private final MageObjectReference mor;

    RadiantScrollwielderReplacementEffect(Card card, Game game) {
        super(Duration.EndOfTurn, Outcome.Exile);
        this.mor = new MageObjectReference((MageObject)card, game, 1);
    }

    private RadiantScrollwielderReplacementEffect(RadiantScrollwielderReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.mor = effect.mor;
    }

    public RadiantScrollwielderReplacementEffect copy() {
        return new RadiantScrollwielderReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return ((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD && this.mor.refersTo((MageObject)game.getCard(event.getSourceId()), game) && RadiantScrollwielderWatcher.checkSpell(game.getCard(event.getSourceId()), source, game);
    }
}

