/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashSet;
import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class RaidingPartyEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("untapped white creatures");
    private static final FilterPermanent filter2 = new FilterPermanent("Plains");

    RaidingPartyEffect() {
        super(Outcome.Detriment);
        this.staticText = "Each player may tap any number of untapped white creatures they control. For each creature tapped this way, that player chooses up to two Plains. Then destroy all Plains that weren't chosen this way by any player";
    }

    private RaidingPartyEffect(RaidingPartyEffect effect) {
        super((OneShotEffect)effect);
    }

    public RaidingPartyEffect copy() {
        return new RaidingPartyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourcePermanent != null) {
            HashSet<UUID> plainsToSave = new HashSet<UUID>();
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                TargetPermanent plainsToSaveTarget;
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                int countBattlefield = game.getBattlefield().getAllActivePermanents(filter, game.getActivePlayerId(), game).size();
                int tappedCount = 0;
                TargetPermanent untappedCreatureTarget = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
                if (player.choose(Outcome.Benefit, (Target)untappedCreatureTarget, source, game)) {
                    tappedCount = untappedCreatureTarget.getTargets().size();
                    for (UUID creatureId : untappedCreatureTarget.getTargets()) {
                        Permanent creature = game.getPermanentOrLKIBattlefield(creatureId);
                        if (creature == null) continue;
                        creature.tap(source, game);
                    }
                }
                if (tappedCount <= 0 || !player.choose(Outcome.Benefit, (Target)(plainsToSaveTarget = new TargetPermanent(0, tappedCount * 2, filter2, true)), source, game)) continue;
                for (UUID plainsId : plainsToSaveTarget.getTargets()) {
                    plainsToSave.add(plainsId);
                    Permanent plains = game.getPermanent(plainsId);
                    if (plains == null) continue;
                    game.informPlayers(player.getLogName() + " chose " + plains.getLogName() + " to not be destroyed by " + sourcePermanent.getLogName());
                }
            }
            for (Permanent plains : game.getBattlefield().getActivePermanents(filter2, source.getControllerId(), source, game)) {
                if (plainsToSave.contains(plains.getId())) continue;
                plains.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
        filter.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
        filter2.add((Predicate)SubType.PLAINS.getPredicate());
    }
}

