/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.mana.AnyColorManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.r.OpponentGainControlEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public final class RainbowVale
extends CardImpl {
    public RainbowVale(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.LAND}, "");
        AnyColorManaAbility ability = new AnyColorManaAbility();
        ability.addEffect((Effect)new RainbowValeEffect());
        this.addAbility((Ability)ability);
    }

    private RainbowVale(RainbowVale card) {
        super((CardImpl)card);
    }

    public RainbowVale copy() {
        return new RainbowVale(this);
    }

    static class RainbowValeEffect
    extends OneShotEffect {
        public RainbowValeEffect() {
            super(Outcome.PutManaInPool);
            this.staticText = "an opponent gains control of {this} at the beginning of the next end step";
        }

        private RainbowValeEffect(RainbowValeEffect effect) {
            super((OneShotEffect)effect);
        }

        public boolean apply(Game game, Ability source) {
            Permanent permanent = game.getPermanent(source.getSourceId());
            if (permanent != null) {
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new OpponentGainControlEffect()), source);
                return true;
            }
            return false;
        }

        public RainbowValeEffect copy() {
            return new RainbowValeEffect(this);
        }
    }
}

