/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class RakdosAugermageEffect
extends OneShotEffect {
    RakdosAugermageEffect() {
        super(Outcome.Discard);
        this.staticText = "reveal your hand and discard a card of target opponent's choice";
    }

    private RakdosAugermageEffect(RakdosAugermageEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (player != null && controller != null) {
            CardsImpl revealedCards = new CardsImpl();
            revealedCards.addAll((Collection)controller.getHand());
            Card sourceCard = game.getCard(source.getSourceId());
            player.revealCards((sourceCard != null ? sourceCard.getIdName() + " (" + sourceCard.getZoneChangeCounter(game) + ") (" : "Discard (") + controller.getName() + ")", (Cards)revealedCards, game);
            TargetCard target = new TargetCard(Zone.HAND, new FilterCard());
            if (player.choose(Outcome.Benefit, (Cards)revealedCards, target, source, game)) {
                Card card = revealedCards.get(target.getFirstTarget(), game);
                return player.discard(card, false, source, game);
            }
        }
        return false;
    }

    public RakdosAugermageEffect copy() {
        return new RakdosAugermageEffect(this);
    }
}

