/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RakdosRiteknifeEffect
extends ContinuousEffectImpl {
    RakdosRiteknifeEffect() {
        super(Duration.WhileOnBattlefield, Outcome.AddAbility);
        this.staticText = "equipped creature gets +1/+0 for each blood counter on {this} and has \"{T}, Sacrifice a creature: Put a blood counter on {this}.\"";
    }

    private RakdosRiteknifeEffect(RakdosRiteknifeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public RakdosRiteknifeEffect copy() {
        return new RakdosRiteknifeEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        Permanent creature = game.getPermanent(permanent.getAttachedTo());
        if (creature == null) {
            return false;
        }
        switch (layer) {
            case AbilityAddingRemovingEffects_6: {
                creature.addAbility(RakdosRiteknifeEffect.makeAbility(permanent, game), source.getSourceId(), game);
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.ModifyPT_7c) {
                    return false;
                }
                int count = permanent.getCounters(game).getCount(CounterType.BLOOD);
                if (count <= 0) break;
                creature.addPower(count);
                return true;
            }
        }
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.PTChangingEffects_7;
    }

    private static Ability makeAbility(Permanent permanent, Game game) {
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new AddCountersTargetEffect(CounterType.BLOOD.createInstance()).setText("put a blood counter on " + permanent.getName()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), (Cost)new TapSourceCost());
        ability.addCost((Cost)new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE));
        return ability;
    }
}

