/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class RakdosTheMuscleEffect
extends OneShotEffect {
    RakdosTheMuscleEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile cards equal to its mana value from the top of target player's library. Until your next end step, you may play those cards, and mana of any type can be spent to cast those spells";
    }

    private RakdosTheMuscleEffect(RakdosTheMuscleEffect effect) {
        super((OneShotEffect)effect);
    }

    public RakdosTheMuscleEffect copy() {
        return new RakdosTheMuscleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        Permanent sacrificed = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (player == null || controller == null || sacrificed == null) {
            return false;
        }
        int amount = sacrificed.getManaValue();
        if (amount <= 0) {
            return false;
        }
        Set cards = player.getLibrary().getTopCards(game, amount);
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCardsToExile(cards, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        cards.removeIf(card -> !Zone.EXILED.equals((Object)game.getState().getZone(card.getId())));
        for (Card card2 : cards) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card2, (boolean)false, (Duration)Duration.UntilYourNextEndStep, (boolean)true, (UUID)controller.getId(), null);
        }
        return true;
    }
}

