/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RakdosTheShowstopperEffect
extends OneShotEffect {
    RakdosTheShowstopperEffect() {
        super(Outcome.Benefit);
        this.staticText = "flip a coin for each creature that isn't a Demon, Devil, or Imp. Destroy each creature whose coin comes up tails.";
    }

    private RakdosTheShowstopperEffect(RakdosTheShowstopperEffect effect) {
        super((OneShotEffect)effect);
    }

    public RakdosTheShowstopperEffect copy() {
        return new RakdosTheShowstopperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (permanent == null || !permanent.isCreature(game) || permanent.hasSubtype(SubType.DEMON, game) || permanent.hasSubtype(SubType.DEVIL, game) || permanent.hasSubtype(SubType.IMP, game) || player.flipCoin(source, game, false)) continue;
            permanent.destroy(source, game, false);
        }
        return true;
    }
}

