/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageIdentifier;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.common.EntersBattlefieldAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.InstantAndSorceryCastThisTurn;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageMultiEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.r.RalLeylineProdigyCostReductionEffect;
import mage.cards.r.RalLeylineProdigyMinusEightEffect;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.target.Target;
import mage.target.common.TargetAnyTargetAmount;

public final class RalLeylineProdigy
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("blue permanent other than {this}");
    private static final Condition condition = new PermanentsOnTheBattlefieldCondition(filter, true);
    private static final Hint hint = new ConditionHint(condition, "you control another blue permanent");

    public RalLeylineProdigy(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.RAL);
        this.setStartingLoyalty(2);
        this.color.setBlue(true);
        this.color.setRed(true);
        this.nightCard = true;
        this.addAbility(new EntersBattlefieldAbility((Effect)new AddCountersSourceEffect(CounterType.LOYALTY.createInstance(), (DynamicValue)InstantAndSorceryCastThisTurn.YOU, false).setText("with an additional loyalty counter on him for each instant and sorcery spell you've cast this turn")).addHint(InstantAndSorceryCastThisTurn.YOU.getHint()));
        this.addAbility((Ability)new LoyaltyAbility((Effect)new RalLeylineProdigyCostReductionEffect(), 1));
        LoyaltyAbility ability = new LoyaltyAbility((Effect)new DamageMultiEffect(), -2);
        ability.addTarget((Target)new TargetAnyTargetAmount(2));
        ability.addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new DrawCardSourceControllerEffect(1), condition, "Draw a card if you control a blue permanent other than {this}"));
        ability.addHint(hint);
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new LoyaltyAbility((Effect)new RalLeylineProdigyMinusEightEffect(), -8).setIdentifier(MageIdentifier.WithoutPayingManaCostAlternateCast));
    }

    private RalLeylineProdigy(RalLeylineProdigy card) {
        super((CardImpl)card);
    }

    public RalLeylineProdigy copy() {
        return new RalLeylineProdigy(this);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLUE));
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

